/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil.security.base;

import filenet.vw.ntutil.VWNTUTIL_DLL;
import filenet.vw.ntutil.security.base.NTSecurityToken;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.trace;

public class NativeSSPIPackage {
    private static int SIZE;
    private static Boolean SSPIDLLLoaded;

    private static native int initSSPIPackage() throws Exception;

    private static native void releaseSSPIPackage() throws Exception;

    private static native NTSecurityToken SSPIImpersonateContext(SSPISecHandle var0) throws Exception;

    private static native boolean SSPIRevertContext(SSPISecHandle var0) throws Exception;

    public static int getPackageBufSize() {
        return SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init() {
        try {
            if (VWNTUTIL_DLL.initLibrary()) {
                Boolean bl = SSPIDLLLoaded;
                synchronized (bl) {
                    if (!SSPIDLLLoaded.booleanValue()) {
                        SIZE = NativeSSPIPackage.initSSPIPackage();
                    }
                    SSPIDLLLoaded = Boolean.TRUE;
                    trace.println("NativeSSPIPackage.init, Buf Size = " + Integer.toString(SIZE));
                    return true;
                }
            }
        }
        catch (Throwable t) {
            trace.println("NativeSSPIPackage.init, got Throwable=" + t.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        try {
            Boolean bl = SSPIDLLLoaded;
            synchronized (bl) {
                if (SSPIDLLLoaded.booleanValue()) {
                    NativeSSPIPackage.releaseSSPIPackage();
                }
                SSPIDLLLoaded = Boolean.FALSE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static NTSecurityToken impersonateContext(SSPISecHandle svrContext) throws Exception {
        NTSecurityToken result = NativeSSPIPackage.SSPIImpersonateContext(svrContext);
        if (result != null) {
            trace.println("NativeSSPIPackage impersonateContext get token = " + result.toString());
        }
        return result;
    }

    public static boolean revertContext(SSPISecHandle svrContext) throws Exception {
        return NativeSSPIPackage.SSPIRevertContext(svrContext);
    }

    static {
        VWNTUTIL_DLL.initLibrary();
        SIZE = 0;
        SSPIDLLLoaded = Boolean.FALSE;
    }
}

